export class TFJSDetector{
  constructor(o={}){ this.modelUrl=o.modelUrl||'models/model_web/model.json'; this.labelsUrl=o.labelsUrl||'models/labels.json'; this.inputSize=o.inputSize||224; this.threshold=o.threshold||0.6; this._labels=[]; this._model=null; this._isGraph=true; this._ema=null; }
  async _ensureTF(){ if(window.tf) return; await new Promise((res,rej)=>{ const s=document.createElement('script'); s.src='https://cdn.jsdelivr.net/npm/@tensorflow/tfjs@4.20.0/dist/tf.min.js'; s.onload=()=>res(); s.onerror=()=>rej(new Error('TFJS load error')); document.head.appendChild(s); }); }
  async init(){ await this._ensureTF(); try{ this._model=await tf.loadGraphModel(this.modelUrl); this._isGraph=true; }catch(e){ this._model=await tf.loadLayersModel(this.modelUrl); this._isGraph=false; } this._labels=await (await fetch(this.labelsUrl)).json(); return true; }
  _pre(v){ return tf.tidy(()=>{ let img=tf.browser.fromPixels(v); const [h,w]=img.shape; const side=Math.min(h,w); const top=((h-side)/2)|0, left=((w-side)/2)|0; img=img.slice([top,left,0],[side,side,3]).resizeBilinear([this.inputSize,this.inputSize]).toFloat().div(255).expandDims(0); return img; }); }
  _soft(arr){ const m=Math.max(...arr), ex=arr.map(x=>Math.exp(x-m)), s=ex.reduce((a,b)=>a+b,0); return ex.map(x=>x/s); }
  _emaUpd(v){ if(!this._ema) this._ema=v; else this._ema=this._ema.map((x,i)=>0.6*v[i]+0.4*x); return this._ema; }
  async infer(video){ if(!this._model) throw new Error('init() primero'); const x=this._pre(video); const y=this._isGraph? this._model.execute(x) : this._model.predict(x); const logits=await y.data(); tf.dispose([x,y]); const probs=this._emaUpd(this._soft(Array.from(logits))); let best=0; for(let i=1;i<probs.length;i++) if(probs[i]>probs[best]) best=i; const label=this._labels[best]||`class_${best}`; const conf=probs[best]; return conf>=this.threshold? {label,confidence:conf} : null; }
}