<?php
declare(strict_types=1);
ini_set('display_errors', '1'); error_reporting(E_ALL);
require_once __DIR__ . '/../config/db.php';
$msgs=[]; $count=0; $ins=0; $upd=0; $skip=0;
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_FILES['csv']) && is_uploaded_file($_FILES['csv']['tmp_name'])){
  if(($fh=fopen($_FILES['csv']['tmp_name'],'r'))!==false){
    $header=fgetcsv($fh); $cols=array_map('trim',$header?:[]); $need=['type','value','ref_url'];
    foreach($need as $n){ if(!in_array($n,$cols,true)){ $msgs[]='Falta columna: '.$n; fclose($fh); $fh=null; break; } }
    if($fh){
      $map=array_flip($cols);
      $sql="INSERT INTO denominations (type,value,family,year_from,year_to,variant,obverse_desc,reverse_desc,ref_url)
            VALUES (?,?,?,?,?,?,?,?,?)
            ON DUPLICATE KEY UPDATE
              family=VALUES(family), year_from=VALUES(year_from), year_to=VALUES(year_to),
              variant=VALUES(variant), obverse_desc=VALUES(obverse_desc), reverse_desc=VALUES(reverse_desc),
              ref_url=VALUES(ref_url)";
      $st=$pdo->prepare($sql);
      while(($row=fgetcsv($fh))!==false){
        $count++;
        $type=strtolower(trim($row[$map['type']] ?? ''));
        $value=(int)($row[$map['value']] ?? 0);
        $family=trim($row[$map['family']] ?? '');
        $yf = ($row[$map['year_from']] ?? '')!=='' ? (int)$row[$map['year_from']] : null;
        $yt = ($row[$map['year_to']] ?? '')!=='' ? (int)$row[$map['year_to']] : null;
        $variant=trim($row[$map['variant']] ?? '');
        $obv=trim($row[$map['obverse_desc']] ?? '');
        $rev=trim($row[$map['reverse_desc']] ?? '');
        $url=trim($row[$map['ref_url']] ?? '');
        if(!in_array($type,['billete','moneda'],true) || !$value || !$url){ $skip++; continue; }
        try{ $st->execute([$type,$value,$family,$yf,$yt,$variant,$obv,$rev,$url]); if($st->rowCount()===1) $ins++; else $upd++; }
        catch(Throwable $e){ $msgs[]='Error fila '.$count.': '.$e->getMessage(); $skip++; }
      }
      fclose($fh);
    }
  } else { $msgs[]='No se pudo abrir el CSV'; }
}
?>
<!doctype html><html lang="es"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Importador CSV — Denominations</title>
<style>body{font-family:system-ui,Segoe UI,Roboto,Arial;margin:24px;max-width:820px}.card{border:1px solid #ddd;border-radius:12px;padding:16px;margin-bottom:16px}.small{font-size:12px;opacity:.75}.msgs{color:#b10}</style>
</head><body>
<h2>Importador CSV — Denominations</h2>
<div class="card">
<form method="post" enctype="multipart/form-data">
  <p>Columnas: <strong>type,value,family,year_from,year_to,variant,obverse_desc,reverse_desc,ref_url</strong></p>
  <input type="file" name="csv" accept=".csv" required>
  <button type="submit">Importar</button>
</form>
</div>
<?php if($count): ?>
<div class="card small">Procesadas: <b><?= $count ?></b> · Insertadas: <b><?= $ins ?></b> · Actualizadas: <b><?= $upd ?></b> · Omitidas: <b><?= $skip ?></b></div>
<?php endif; ?>
<?php if($msgs): ?><div class="msgs"><?php foreach($msgs as $m) echo "<p>".htmlspecialchars($m)."</p>"; ?></div><?php endif; ?>
</body></html>
