<?php
declare(strict_types=1);
ini_set('display_errors','1'); error_reporting(E_ALL);
require_once __DIR__ . '/../config/db.php';

function clean_text(string $t): string {
  $t = preg_replace('/<[^>]+>/', ' ', $t);
  $t = html_entity_decode($t ?? '', ENT_QUOTES | ENT_HTML5, 'UTF-8');
  $t = preg_replace('/\s+/',' ', $t);
  return trim($t);
}
function detect_type(string $t): string {
  $l = mb_strtolower($t);
  if (strpos($l, 'moneda') !== false) return 'moneda';
  if (preg_match('/\bb\d{3,4}\b/i', $t) || strpos($l,'billete')!==false || strpos($l,'pesos oro')!==false) return 'billete';
  return 'billete';
}
function extract_value(string $t): ?int {
  $l = mb_strtolower($t);
  if (preg_match('/(\d{1,3})\s*mil\s*pesos?/u', $l, $m)) return (int)$m[1] * 1000;
  if (preg_match('/(\d{1,6}(?:[\.,]\d{3})+|\d{1,6})\s*pesos?/u', $l, $m)){
    $n = (int)str_replace([',','.'], '', $m[1]);
    return $n;
  }
  if (preg_match('/(\d{1,6})\s*peso\b/u', $l, $m)) return (int)$m[1];
  if (preg_match('/(\d{1,3})\s*mil\b/u', $l, $m)) return (int)$m[1]*1000;
  return null;
}
function extract_year(string $t): ?int {
  if (preg_match('/\b(18|19|20)\d{2}\b/u', $t, $m)) return (int)$m[0];
  return null;
}
function extract_family(string $t): string {
  if (preg_match('/\b([bm]\d{3,4})\b/i', $t, $m)) return strtoupper($m[1]);
  $y = extract_year($t);
  return $y ? (string)$y : '';
}
function extract_variant(string $t): string {
  $l = mb_strtolower($t);
  $tokens = [];
  if (strpos($l,'reposici')!==false) $tokens[]='reposicion';
  if (preg_match('/\br peque(ñ|n)a\b/u', $l)) $tokens[]='R_pequena';
  if (preg_match('/\br grande\b/u', $l)) $tokens[]='R_grande';
  if (preg_match('/\bfirma(s)?\b/u', $l)) $tokens[]='firmas';
  return implode('_', $tokens);
}

$msgs=[]; $stats=['raw'=>0,'parsed'=>0,'skipped'=>0,'updated'=>0,'inserted'=>0];

if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_FILES['csv']) && is_uploaded_file($_FILES['csv']['tmp_name'])) {
  $fh = fopen($_FILES['csv']['tmp_name'], 'r');
  if (!$fh) { $msgs[]='No se pudo abrir el CSV'; }
  else {
    $header = fgetcsv($fh);
    $cols = array_map(fn($x)=> strtolower(trim((string)$x)), $header ?: []);
    $map = ['nombre'=>null,'contenido'=>null,'link'=>null];
    foreach ($cols as $i=>$c){
      if (in_array($c, ['nombre','name','title','post_title'])) $map['nombre']=$i;
      if (in_array($c, ['contenido','content','post_content','body'])) $map['contenido']=$i;
      if (in_array($c, ['link','url','permalink','guid'])) $map['link']=$i;
    }
    if ($map['nombre']===null) $map['nombre']=0;
    if ($map['contenido']===null) $map['contenido']=1;
    if ($map['link']===null) $map['link']=count($cols)-1;

    $sqlUp = "INSERT INTO denominations (type,value,family,year_from,year_to,variant,obverse_desc,reverse_desc,ref_url)
              VALUES (?,?,?,?,?,?,?,?,?)
              ON DUPLICATE KEY UPDATE
                family=VALUES(family),
                year_from = IF(VALUES(year_from) IS NULL, year_from, IF(year_from IS NULL, VALUES(year_from), LEAST(year_from, VALUES(year_from)))),
                year_to   = IF(VALUES(year_to)   IS NULL, year_to,   IF(year_to   IS NULL, VALUES(year_to),   GREATEST(year_to, VALUES(year_to)))),
                variant=VALUES(variant),
                obverse_desc=VALUES(obverse_desc),
                reverse_desc=VALUES(reverse_desc),
                ref_url=VALUES(ref_url)";
    $up = $pdo->prepare($sqlUp);

    while (($row = fgetcsv($fh)) !== false) {
      $stats['raw']++;
      $nombre = clean_text($row[$map['nombre']] ?? '');
      $contenido = clean_text($row[$map['contenido']] ?? '');
      $link = trim((string)($row[$map['link']] ?? ''));

      if ($nombre==='' && $contenido==='' && $link===''){ $stats['skipped']++; continue; }
      $blob = $nombre . ' ' . $contenido;
      $type = detect_type($blob);
      $value= extract_value($blob);
      if ($value===null){ $stats['skipped']++; continue; }
      $year = extract_year($blob);
      $family = extract_family($blob);
      $variant = extract_variant($blob);
      $obv = mb_substr($nombre, 0, 140);

      try{
        $up->execute([$type,$value,$family,$year,$year,$variant,$obv,'',$link]);
        $stats['parsed']++;
        if ($up->rowCount()===1) $stats['inserted']++; else $stats['updated']++;
      } catch(Throwable $e){
        $msgs[] = 'Error: '.$e->getMessage();
        $stats['skipped']++;
      }
    }
    fclose($fh);
  }
}
?>
<!doctype html><html lang="es"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Importar Numismaticol (3 columnas)</title>
<style>
body{font-family:system-ui,Segoe UI,Roboto,Arial;margin:24px;max-width:900px}
.card{border:1px solid #ddd;border-radius:12px;padding:16px;margin-bottom:16px}
.small{font-size:12px;opacity:.75}
.msgs{color:#b10}
.kv{display:grid;grid-template-columns:180px 1fr;gap:6px}
</style></head><body>
<h2>Importar Numismaticol — CSV (nombre, contenido, link)</h2>
<div class="card">
<form method="post" enctype="multipart/form-data">
  <p>Sube el CSV exportado (3 columnas: <strong>nombre</strong>, <strong>contenido</strong>, <strong>link</strong> — se aceptan alias como title/post_content/permalink).</p>
  <input type="file" name="csv" accept=".csv" required>
  <button type="submit">Importar</button>
</form>
</div>
<div class="card">
  <h3>Resultado</h3>
  <div class="kv">
    <div>Filas leídas (raw):</div><div><?= $stats['raw'] ?></div>
    <div>Normalizadas (OK):</div><div><?= $stats['parsed'] ?></div>
    <div>Insertadas:</div><div><?= $stats['inserted'] ?></div>
    <div>Actualizadas:</div><div><?= $stats['updated'] ?></div>
    <div>Omitidas:</div><div><?= $stats['skipped'] ?></div>
  </div>
  <?php if($msgs): ?><div class="msgs"><?php foreach($msgs as $m) echo "<p>".htmlspecialchars($m)."</p>"; ?></div><?php endif; ?>
</div>
</body></html>
