<?php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__.'/../config/db.php';
require_once __DIR__.'/../config/env.php';

$token = $_SERVER['HTTP_X_API_KEY'] ?? '';
if ($token !== APP_TOKEN) { http_response_code(401); echo json_encode(['ok'=>false,'msg'=>'unauthorized']); exit; }

$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
$items = $data['items'] ?? null;
if (!$items || !is_array($items)) { echo json_encode(['ok'=>false,'msg'=>'no items']); exit; }

$sql = "INSERT INTO denominations (type,value,family,year_from,year_to,variant,obverse_desc,reverse_desc,ref_url)
        VALUES (?,?,?,?,?,?,?,?,?)
        ON DUPLICATE KEY UPDATE
          family=VALUES(family), year_from=VALUES(year_from), year_to=VALUES(year_to),
          variant=VALUES(variant), obverse_desc=VALUES(obverse_desc), reverse_desc=VALUES(reverse_desc),
          ref_url=VALUES(ref_url)";
$st = $pdo->prepare($sql);

$ins=0; $upd=0; $skip=0; $errs=[];
foreach ($items as $i) {
  $type = strtolower(trim($i['type'] ?? ''));
  $value = (int)($i['value'] ?? 0);
  $family = trim($i['family'] ?? '');
  $yf = isset($i['year_from']) && $i['year_from']!=='' ? (int)$i['year_from'] : null;
  $yt = isset($i['year_to']) && $i['year_to']!=='' ? (int)$i['year_to'] : null;
  $variant = trim($i['variant'] ?? '');
  $obv = trim($i['obverse_desc'] ?? '');
  $rev = trim($i['reverse_desc'] ?? '');
  $url = trim($i['ref_url'] ?? '');
  if (!in_array($type,['billete','moneda'],true) || !$value || !$url) { $skip++; continue; }
  try{
    $st->execute([$type,$value,$family,$yf,$yt,$variant,$obv,$rev,$url]);
    if ($st->rowCount()===1) $ins++; else $upd++;
  }catch(Throwable $e){ $errs[]=$e->getMessage(); $skip++; }
}
echo json_encode(['ok'=>true,'inserted'=>$ins,'updated'=>$upd,'skipped'=>$skip,'errors'=>$errs]);
