import { createDetector } from './detector_factory.js';
const video=document.getElementById('video'); const canvas=document.getElementById('frame'); const ctx=canvas.getContext('2d');
const btnStart=document.getElementById('btn-start'); const btnScan=document.getElementById('btn-scan'); const btnOpen=document.getElementById('btn-open');
const statusBadge=document.getElementById('status-badge'); const outLabel=document.getElementById('out-label'); const outConf=document.getElementById('out-conf');
const outParsed=document.getElementById('out-parsed'); const outUrl=document.getElementById('out-url'); const outSharp=document.getElementById('out-sharp'); const outRois=document.getElementById('out-rois');
const toggleMock=document.getElementById('toggle-mock'); const toggleFine=document.getElementById('toggle-fine');
const selType=document.getElementById('sel-type'); const selValue=document.getElementById('sel-value'); const inpYear=document.getElementById('inp-year'); const inpVariant=document.getElementById('inp-variant'); const inpFamily=document.getElementById('inp-family');
const btnManual=document.getElementById('btn-manual'); const btnOpenManual=document.getElementById('btn-open-manual');
let stream=null, detector=null;
function setStatus(t){ statusBadge.textContent=t; }
function parseLabel(label){ const p=label.split('_'); if(p[0]==='billete') return {type:'billete',value:parseInt(p[1]||'0',10),side:p[2]||null}; if(p[0]==='moneda') return {type:'moneda',value:parseInt(p[1]||'0',10),side:null}; return null; }
function showResult(res){ if(!res){ outLabel.textContent='—'; outConf.textContent='—'; outParsed.textContent='—'; outUrl.textContent='—'; outSharp.textContent='—'; outRois.textContent='—'; btnOpen.disabled=true; return; } outLabel.textContent=res.label; outConf.textContent=(res.confidence*100).toFixed(1)+'%'; const p=parseLabel(res.label); outParsed.textContent=p?`${p.type} ${p.value}${p.side?(' ('+p.side+')'):''}`:'—'; outUrl.textContent='resolviendo…'; outSharp.textContent='—'; outRois.textContent='—'; btnOpen.disabled=true; }
async function startCamera(){ try{ stream=await navigator.mediaDevices.getUserMedia({video:{facingMode:'environment'},audio:false}); video.srcObject=stream; setStatus('Cámara encendida'); }catch(e){ setStatus('Error cámara: '+e.message); } }
async function ensureDetector(){ const useAI=!toggleMock.checked; detector=await createDetector(useAI); setStatus(useAI?'Detector IA listo':'Detector simulado listo'); }
function grabFrame(){ const w=video.videoWidth,h=video.videoHeight; if(!w||!h) return false; canvas.width=w; canvas.height=h; ctx.drawImage(video,0,0,w,h); return true; }
function matFromCanvas(){ try{ return cv.imread(canvas);}catch(e){ return null; } }
function computeSharpness(mat){ try{ let gray=new cv.Mat(); cv.cvtColor(mat,gray,cv.COLOR_RGBA2GRAY); let lap=new cv.Mat(); cv.Laplacian(gray,lap,cv.CV_64F); let mean=new cv.Mat(), std=new cv.Mat(); cv.meanStdDev(lap,mean,std); const v=Math.pow(std.doubleAt(0,0),2); gray.delete(); lap.delete(); mean.delete(); std.delete(); return v; }catch(e){ return null; } }
function cropRel(mat,x,y,w,h){ const rx=Math.max(0,Math.min(mat.cols-1,Math.round(x*mat.cols))); const ry=Math.max(0,Math.min(mat.rows-1,Math.round(y*mat.rows))); const rw=Math.max(1,Math.round(w*mat.cols)); const rh=Math.max(1,Math.round(h*mat.rows)); const rect=new cv.Rect(rx,ry,Math.min(rw,mat.cols-rx),Math.min(rh,mat.rows-ry)); return mat.roi(rect); }
function loadImageToMat(url){ return new Promise((resolve,reject)=>{ const img=new Image(); img.onload=()=>{ const off=document.createElement('canvas'); off.width=img.width; off.height=img.height; off.getContext('2d').drawImage(img,0,0); try{ resolve(cv.imread(off)); }catch(err){ reject(err);} }; img.onerror=(e)=>reject(e); img.src=url; }); }
async function verifyFine(label){ if(!toggleFine.checked) return {ok:true,skipped:true,detail:'fine off'}; if(!window.__cvReady||typeof cv==='undefined') return {ok:true,skipped:true,detail:'opencv no disp.'}; if(!grabFrame()) return {ok:false,skipped:true,detail:'no frame'}; const mat=matFromCanvas(); if(!mat) return {ok:false,skipped:true,detail:'cv.imread fail'}; const sharp=computeSharpness(mat)||0; outSharp.textContent=sharp.toFixed(0); if(sharp<100){ mat.delete(); return {ok:false,skipped:false,detail:'imagen borrosa'}; } let conf=null; try{ conf=await (await fetch('js/rois.json')).json(); }catch(e){ mat.delete(); return {ok:true,skipped:true,detail:'sin rois'}; } const spec=conf[label]; if(!spec){ mat.delete(); return {ok:true,skipped:true,detail:'no spec'}; } const need=Math.min(spec.open_rule?.k||0,(spec.rois||[]).length||0); if(need===0){ mat.delete(); outRois.textContent='(ROIs omitidos)'; return {ok:true,skipped:false,detail:'omiso'}; } let passed=0,total=0,msgs=[]; for(const r of spec.rois||[]){ total++; try{ const roi=cropRel(mat,r.x,r.y,r.w,r.h); const tpl=await loadImageToMat(r.tpl); const res=new cv.Mat(); cv.matchTemplate(roi,tpl,res,cv.TM_CCOEFF_NORMED); const mm=cv.minMaxLoc(res); const ok=mm.maxVal>=(r.th||0.7); if(ok) passed++; msgs.push(`${r.name}: ${ok?'✅':'❌'} (${mm.maxVal.toFixed(2)})`); res.delete(); tpl.delete(); roi.delete(); }catch(e){ msgs.push(`${r.name}: ❌ (error)`);} } outRois.textContent=msgs.join(' | '); mat.delete(); return {ok:passed>=need,skipped:false,detail:`${passed}/${total} OK`}; }
async function resolveGuide(payload){ const fd=new FormData(); Object.entries(payload).forEach(([k,v])=>{ if(v!==undefined&&v!==null&&v!=='') fd.append(k,v); }); const r=await fetch(`${API_BASE}/resolve.php`,{method:'POST',body:fd}); const j=await r.json(); return j?.url||null; }
btnStart.onclick=async()=>{ await startCamera(); await ensureDetector(); };
btnScan.onclick=async()=>{ if(!stream) await startCamera(); if(!detector) await ensureDetector(); setStatus('Buscando...'); const res=await detector.infer(video); if(!res){ setStatus('Sin detección'); showResult(null); return; } setStatus('Detectado'); showResult(res); const fine=await verifyFine(res.label); if(!fine.ok){ setStatus('Verificación: '+fine.detail); return; } const p=parseLabel(res.label); const family=inpFamily.value.trim(); const url=await resolveGuide({type:p?.type,value:p?.value,family}); if(url){ outUrl.innerHTML=`<a href="${url}" target="_blank" rel="noopener">${url}</a>`; btnOpen.disabled=false; btnOpen.onclick=()=>window.open(url,'_blank'); } else { outUrl.textContent='No encontrada'; } };
btnManual.onclick=async()=>{ const type=selType.value,value=selValue.value,year=inpYear.value.trim(),variant=inpVariant.value.trim(),family=inpFamily.value.trim(); const label=`${type}_${value}_anverso`; showResult({label,confidence:0.99}); const fine=await verifyFine(label); if(!fine.ok){ setStatus('Verificación: '+fine.detail); btnOpenManual.disabled=true; return; } const url=await resolveGuide({type,value,year,variant,family}); if(url){ outUrl.innerHTML=`<a href="${url}" target="_blank" rel="noopener">${url}</a>`; btnOpenManual.disabled=false; btnOpenManual.onclick=()=>window.open(url,'_blank'); } else { outUrl.textContent='No encontrada'; btnOpenManual.disabled=true; } };
