const video=document.getElementById('video'), canvas=document.getElementById('frame'), ctx=canvas.getContext('2d');
const btnStart=document.getElementById('btn-start'), btnScan=document.getElementById('btn-scan'), btnOpen=document.getElementById('btn-open');
const btnCapture=document.getElementById('btn-capture'), statusBadge=document.getElementById('status-badge');
const outLabel=document.getElementById('out-label'), outConf=document.getElementById('out-conf'), outParsed=document.getElementById('out-parsed');
const outUrl=document.getElementById('out-url'), outSharp=document.getElementById('out-sharp'), outRois=document.getElementById('out-rois');
const toggleFine=document.getElementById('toggle-fine');
const selType=document.getElementById('sel-type'), selValue=document.getElementById('sel-value'), inpYear=document.getElementById('inp-year');
const inpVariant=document.getElementById('inp-variant'), inpFamily=document.getElementById('inp-family');
const btnManual=document.getElementById('btn-manual'), btnOpenManual=document.getElementById('btn-open-manual');
const btnHelp=document.getElementById('btn-help'), helpBox=document.getElementById('assistant-help');

let stream=null;
function setStatus(t){ statusBadge.textContent=t; }
function parseLabel(label){ const p=label.split('_'); if(p[0]==='billete') return {type:'billete',value:parseInt(p[1]||'0',10),side:p[2]||null}; if(p[0]==='moneda') return {type:'moneda',value:parseInt(p[1]||'0',10),side:null}; return null; }
function showResult(res){ if(!res){ outLabel.textContent='—'; outConf.textContent='—'; outParsed.textContent='—'; outUrl.textContent='—'; outSharp.textContent='—'; outRois.textContent='—'; btnOpen.disabled=true; return; } outLabel.textContent=res.label; outConf.textContent=(res.confidence*100).toFixed(1)+'%'; const p=parseLabel(res.label); outParsed.textContent=p?`${p.type} ${p.value}${p.side?(' ('+p.side+')'):''}`:'—'; outUrl.textContent='resolviendo…'; outSharp.textContent='—'; outRois.textContent='—'; btnOpen.disabled=true; }
async function startCamera(){ try{ stream=await navigator.mediaDevices.getUserMedia({video:{facingMode:'environment'},audio:false}); video.srcObject=stream; setStatus('Cámara encendida'); }catch(e){ setStatus('Error cámara: '+e.message); } }
function grabFrame(){ const w=video.videoWidth,h=video.videoHeight; if(!w||!h) return false; canvas.width=w; canvas.height=h; ctx.drawImage(video,0,0,w,h); return true; }
function downloadFrame(){ if(!grabFrame()) return; canvas.toBlob((blob)=>{ const a=document.createElement('a'); a.href=URL.createObjectURL(blob); a.download='captura_billete.png'; document.body.appendChild(a); a.click(); URL.revokeObjectURL(a.href); a.remove(); }, 'image/png', 0.95); }

btnHelp.onclick=(e)=>{ e.preventDefault(); helpBox.style.display=helpBox.style.display==='none'?'block':'none'; };
btnStart.onclick=async()=> startCamera();
btnCapture.onclick=()=> downloadFrame();

async function resolveGuide(payload){ const r=await fetch('../api/resolve.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify(payload)}); const j=await r.json(); return j?.url||null; }

btnScan.onclick=async()=>{
  if(!stream) await startCamera();
  setStatus('Modo simple — usa Asistente si necesitas mayor precisión');
  const type='billete', value=parseInt(selValue.value,10)||10;
  showResult({label:`${type}_${value}_anverso`,confidence:0.6});
  const family=inpFamily.value.trim(), year=(inpYear.value||'').trim(), variant=(inpVariant.value||'').trim();
  const url=await resolveGuide({type,value,family,year:year?parseInt(year,10):null,variant});
  if(url){ outUrl.innerHTML=`<a class="link" href="${url}" target="_blank" rel="noopener">${url}</a>`; btnOpen.disabled=false; btnOpen.onclick=()=>window.open(url,'_blank'); }
  else{ outUrl.textContent='No encontrada (usa Asistente)'; }
};

btnManual.onclick=async()=>{
  const type=selType.value, value=parseInt(selValue.value,10), family=inpFamily.value.trim(), year=(inpYear.value||'').trim(), variant=(inpVariant.value||'').trim();
  showResult({label:`${type}_${value}_anverso`,confidence:0.99});
  const url=await resolveGuide({type,value,family,year:year?parseInt(year,10):null,variant});
  if(url){ outUrl.innerHTML=`<a class="link" href="${url}" target="_blank" rel="noopener">${url}</a>`; btnOpenManual.disabled=false; btnOpenManual.onclick=()=>window.open(url,'_blank'); }
  else{ outUrl.textContent='No encontrada (revisa family/año o usa Asistente)'; btnOpenManual.disabled=true; }
};
