
CREATE TABLE IF NOT EXISTS denominations (
  id INT AUTO_INCREMENT PRIMARY KEY,
  type ENUM('billete','moneda') NOT NULL,
  value INT NOT NULL,
  family VARCHAR(50) DEFAULT '',
  year_from INT NULL,
  year_to   INT NULL,
  variant   VARCHAR(80) NOT NULL DEFAULT '',
  obverse_desc VARCHAR(150) DEFAULT '',
  reverse_desc VARCHAR(150) DEFAULT '',
  ref_url VARCHAR(255) NOT NULL,
  UNIQUE KEY ux_type_value_variant (type, value, variant)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS scans (
  id INT AUTO_INCREMENT PRIMARY KEY,
  ts DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  label VARCHAR(64) NOT NULL,
  confidence DECIMAL(6,5) NOT NULL DEFAULT 0,
  type ENUM('billete','moneda') NULL,
  value INT NULL,
  side VARCHAR(16) NULL,
  url VARCHAR(255) NULL,
  user_agent VARCHAR(255) NULL,
  ip VARCHAR(64) NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
