<?php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__.'/../config/db.php';

$label=$type=$variant=$family=''; $value=0; $year=0;

$ct = $_SERVER['CONTENT_TYPE'] ?? '';
if (stripos($ct,'application/json')!==false) {
  $j = json_decode(file_get_contents('php://input'), true) ?: [];
  $label  = trim($j['label'] ?? '');
  $type   = trim($j['type'] ?? '');
  $value  = (int)($j['value'] ?? 0);
  $year   = (int)($j['year'] ?? 0);
  $variant= trim($j['variant'] ?? '');
  $family = trim($j['family'] ?? '');
} else {
  $label  = trim($_POST['label'] ?? '');
  $type   = trim($_POST['type'] ?? '');
  $value  = (int)($_POST['value'] ?? 0);
  $year   = (int)($_POST['year'] ?? 0);
  $variant= trim($_POST['variant'] ?? '');
  $family = trim($_POST['family'] ?? '');
}

function parseLabel($label){
  $p = explode('_', $label);
  if ($p[0]==='billete') return ['billete', (int)($p[1]??0)];
  if ($p[0]==='moneda')  return ['moneda',  (int)($p[1]??0)];
  return [null,null];
}
if ($label && (!$type || !$value)) { [$type,$value] = parseLabel($label); }
if (!$type || !$value){ echo json_encode(['ok'=>false,'msg'=>'invalid params']); exit; }

$sql = "SELECT ref_url FROM denominations WHERE type=? AND value=?";
$params = [$type,$value];
if ($family!==''){ $sql.=" AND family=?"; $params[]=$family; }
if ($year){ $sql.=" AND ((year_from IS NULL OR year_from<=?) AND (year_to IS NULL OR (year_to>=? OR year_to IS NULL)))"; $params[]=$year; $params[]=$year; }
if ($variant!==''){ $sql.=" AND variant=?"; $params[]=$variant; }
$sql .= " ORDER BY COALESCE(year_from,0) DESC LIMIT 1";
$st=$pdo->prepare($sql); $st->execute($params);
$row=$st->fetch();
echo json_encode($row? ['ok'=>true,'url'=>$row['ref_url']] : ['ok'=>false,'msg'=>'not found']);
