<?php
require_once __DIR__.'/env.php';

function openai_chat_vision_extract(array $images_dataurls, string $instruction){
  $apiKey = OPENAI_API_KEY;
  if (!$apiKey || $apiKey === 'REEMPLAZAR_OPENAI_API_KEY'){
    http_response_code(500);
    echo json_encode(['ok'=>false,'msg'=>'Falta configurar OPENAI_API_KEY']); exit;
  }
  $model = OPENAI_VISION_MODEL;

  $content = [
    ['type'=>'text','text'=>$instruction]
  ];
  foreach ($images_dataurls as $d) {
    $content[] = ['type'=>'image_url','image_url'=>['url'=>$d]];
  }

  $payload = [
    'model' => $model,
    'response_format' => ['type'=>'json_object'],
    'messages' => [
      ['role'=>'system','content'=>'Eres un experto en numismática colombiana. Devuelve SIEMPRE JSON válido con las claves solicitadas. Nunca texto adicional.'],
      ['role'=>'user','content'=>$content],
    ],
    'temperature' => 0.2,
  ];

  $ch = curl_init('https://api.openai.com/v1/chat/completions');
  curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
      'Authorization: Bearer '.$apiKey,
      'Content-Type: application/json'
    ],
    CURLOPT_POSTFIELDS => json_encode($payload),
    CURLOPT_TIMEOUT => 60
  ]);
  $res = curl_exec($ch);
  if ($res === false) {
    return ['ok'=>false,'msg'=>'OpenAI error: '.curl_error($ch)];
  }
  $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);

  $j = json_decode($res, true);
  if ($http >= 400) {
    return ['ok'=>false,'msg'=>'OpenAI HTTP '.$http, 'detail'=>$j];
  }
  $content = $j['choices'][0]['message']['content'] ?? '';
  $data = json_decode($content, true);
  if (!$data) {
    return ['ok'=>false,'msg'=>'OpenAI no devolvió JSON parseable', 'raw'=>$content];
  }
  return ['ok'=>true,'data'=>$data,'raw'=>$content];
}
