<?php require_once __DIR__.'/../config/env.php'; ?><!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Identificador CO — v5.1 (IA + Progreso)</title>
  <link rel="stylesheet" href="css/styles.css">
</head>
<body>
<header><h1>Identificador de Monedas y Billetes — v5.1 (IA + Progreso)</h1></header>
<div class="container">
  <div class="card">
    <div class="row">
      <div class="col">
        <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:8px;">
          <span class="badge" id="status-badge">Listo</span>
        </div>

        <div class="progress" aria-hidden="true"><div id="pbar" class="progress__bar"></div></div>
        <div id="ptext" class="progress__text">—</div>

        <video id="video" autoplay playsinline muted></video>
        <canvas id="frame" style="display:none;"></canvas>
        <div style="display:flex;gap:8px;margin-top:10px;flex-wrap:wrap">
          <button class="btn btn-tonal" id="btn-start">Encender cámara</button>
          <button class="btn btn-primary" id="btn-ai">Escanear con IA</button>
          <input type="file" id="file" accept="image/*" style="display:none">
          <button class="btn btn-tonal" id="btn-upload">Subir foto</button>
          <a class="btn btn-tonal" target="_blank" rel="noopener" href="<?php echo CHATGPT_GPT_URL; ?>">Abrir Asistente (opcional)</a>
        </div>
        <p class="small" style="margin-top:8px;">La foto se envía a OpenAI sólo para entenderla. No guardamos imágenes.</p>
      </div>
      <div class="col">
        <div class="card" style="margin:0">
          <h3 style="margin-top:0;">Resultado</h3>
          <div class="kv">
            <div><strong>AI → type/value/family:</strong></div><div id="out-parsed">—</div>
            <div><strong>AI confidence:</strong></div><div id="out-conf">—</div>
            <div><strong>URL guía:</strong></div><div id="out-url">—</div>
            <div><strong>Candidatos:</strong></div><div id="out-cands">—</div>
          </div>
          <hr>
          <h4>Corrección manual (opcional)</h4>
          <div class="row">
            <div class="col">
              <label>Tipo</label>
              <select id="sel-type">
                <option value="billete">Billete</option>
                <option value="moneda">Moneda</option>
              </select>
            </div>
            <div class="col">
              <label>Valor</label>
              <select id="sel-value">
                <option>2</option><option>10</option><option>50</option>
                <option>100</option><option>200</option><option>500</option>
                <option>1000</option><option>2000</option>
              </select>
            </div>
          </div>
          <div class="row" style="margin-top:8px;">
            <div class="col"><label>Family</label><input id="inp-family" placeholder="B020, B650, ..."></div>
            <div class="col"><label>Año</label><input id="inp-year" placeholder="1970, 2004, etc."></div>
          </div>
          <div class="row" style="margin-top:8px;">
            <div class="col"><label>Variante</label><input id="inp-variant" placeholder="reposicion, R_pequena..."></div>
          </div>
          <div style="margin-top:8px;display:flex;gap:8px;flex-wrap:wrap">
            <button class="btn btn-tonal" id="btn-manual">Resolver guía (manual)</button>
            <button class="btn btn-primary" id="btn-open-manual" disabled>Abrir guía (manual)</button>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="small" style="opacity:.7;text-align:center;padding:16px 0 28px;">&copy; <?php echo date('Y'); ?> Identificador CO</div>
</div>
<script type="module" src="js/app.js"></script>
</body></html>
