const video=document.getElementById('video'), canvas=document.getElementById('frame'), ctx=canvas.getContext('2d');
const btnStart=document.getElementById('btn-start'), btnAI=document.getElementById('btn-ai'), btnUpload=document.getElementById('btn-upload'), file=document.getElementById('file');
const statusBadge=document.getElementById('status-badge');
const outParsed=document.getElementById('out-parsed'), outConf=document.getElementById('out-conf'), outUrl=document.getElementById('out-url'), outCands=document.getElementById('out-cands');
const selType=document.getElementById('sel-type'), selValue=document.getElementById('sel-value'), inpFamily=document.getElementById('inp-family'), inpYear=document.getElementById('inp-year'), inpVariant=document.getElementById('inp-variant');
const btnManual=document.getElementById('btn-manual'), btnOpenManual=document.getElementById('btn-open-manual');
const pbar=document.getElementById('pbar'), ptext=document.getElementById('ptext');

let stream=null, aiBusy=false;

function setStatus(t){ statusBadge.textContent=t; }
function setProgress(p, text){ pbar.style.width = Math.max(0, Math.min(100, p)) + '%'; ptext.textContent = text || (p+'%'); }

async function startCamera(){ try{ stream=await navigator.mediaDevices.getUserMedia({video:{facingMode:'environment'},audio:false}); video.srcObject=stream; setStatus('Cámara encendida'); }catch(e){ setStatus('Error cámara: '+e.message); } }

function grabDataUrlResized(videoEl, maxW=1280) {
  const w = videoEl.videoWidth, h = videoEl.videoHeight;
  if(!w || !h) return null;
  const scale = w > maxW ? (maxW / w) : 1;
  const cw = Math.round(w * scale), ch = Math.round(h * scale);
  const c = document.createElement('canvas');
  c.width = cw; c.height = ch;
  const cx = c.getContext('2d');
  cx.drawImage(videoEl, 0, 0, cw, ch);
  return c.toDataURL('image/jpeg', 0.9);
}

async function aiIdentifyByDataUrl(dataUrl){
  const r = await fetch('../api/ai_identify.php',{ method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify({ image_data: dataUrl }) });
  const j = await r.json(); return j;
}
async function aiIdentifyByFile(file){
  const fd = new FormData(); fd.append('file', file);
  const r = await fetch('../api/ai_identify.php',{ method:'POST', body: fd });
  const j = await r.json(); return j;
}
async function resolveGuide(payload){
  const r = await fetch('../api/resolve.php',{ method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify(payload) });
  const j = await r.json(); return j?.url||null;
}

function showAI(ai){
  if(!ai){ outParsed.textContent='—'; outConf.textContent='—'; outCands.textContent='—'; return; }
  const {type,value,family,year,variant,confidence,candidates} = ai;
  outParsed.textContent = `${type||'?'} ${value||'?'} ${family||''} ${year||''} ${variant||''}`.trim();
  outConf.textContent = typeof confidence==='number' ? (confidence*100).toFixed(1)+'%' : '—';
  if(Array.isArray(candidates) && candidates.length){
    outCands.textContent = candidates.map(c=>`${c.type||'?'} ${c.value||'?'} ${c.family||''} ${c.year||''} ${c.variant||''} (${Math.round((c.confidence||0)*100)}%)`).join(' | ');
  } else outCands.textContent='—';

  if(type) selType.value = type;
  if(value) selValue.value = String(value);
  if(family) inpFamily.value = family;
  if(year) inpYear.value = String(year);
  if(variant) inpVariant.value = variant;
}

btnStart.onclick=async()=> startCamera();

btnAI.onclick=async()=>{
  if(aiBusy) return;
  aiBusy = true; btnAI.disabled = true;
  try{
    if(!stream) await startCamera();
    setProgress(10, 'Capturando imagen…');
    const d = grabDataUrlResized(video, 1280);
    if(!d){ setStatus('No hay frame de cámara'); setProgress(0,'—'); return; }

    setStatus('Analizando con IA…'); setProgress(35, 'Enviando a IA…');
    const j = await aiIdentifyByDataUrl(d);

    if(!j.ok){
      const detail = j.code==='insufficient_quota' ? 'Cupo de OpenAI agotado.' :
                     (j.http===429 ? 'Límite de solicitudes de OpenAI.' : (j.msg||'Error IA'));
      setStatus('IA: ' + detail);
      setProgress(0,'—');
      return;
    }

    setProgress(70, 'Resolviendo guía…');
    showAI(j.ai);
    const url = await resolveGuide({ type:j.ai.type, value:j.ai.value, family:j.ai.family||'', year:j.ai.year||null, variant:j.ai.variant||'' });
    if(url){ outUrl.innerHTML = `<a class="link" href="${url}" target="_blank" rel="noopener">${url}</a>`; setStatus('Listo'); setProgress(100,'Completado'); }
    else  { outUrl.textContent = 'No encontrada (ajusta family/año/variante)'; setStatus('Revisa campos'); setProgress(0,'—'); }
  }catch(e){
    setStatus('Error: '+e.message); setProgress(0,'—');
  }finally{
    aiBusy = false; btnAI.disabled = false;
  }
};

btnUpload.onclick=()=> file.click();
file.onchange=async(e)=>{
  const f = e.target.files[0]; if(!f) return;
  aiBusy = true; btnAI.disabled=true;
  try{
    setProgress(20,'Subiendo imagen…');
    const j = await aiIdentifyByFile(f);
    if(!j.ok){
      const detail = j.code==='insufficient_quota' ? 'Cupo de OpenAI agotado.' :
                     (j.http===429 ? 'Límite de solicitudes de OpenAI.' : (j.msg||'Error IA'));
      setStatus('IA: ' + detail); setProgress(0,'—'); return;
    }
    setProgress(70,'Resolviendo guía…');
    showAI(j.ai);
    const url = await resolveGuide({ type:j.ai.type, value:j.ai.value, family:j.ai.family||'', year:j.ai.year||null, variant:j.ai.variant||'' });
    if(url){ outUrl.innerHTML = `<a class="link" href="${url}" target="_blank" rel="noopener">${url}</a>`; setStatus('Listo'); setProgress(100,'Completado'); }
    else  { outUrl.textContent = 'No encontrada (ajusta family/año/variante)'; setStatus('Revisa campos'); setProgress(0,'—'); }
  }catch(e){
    setStatus('Error: '+e.message); setProgress(0,'—');
  }finally{
    aiBusy=false; btnAI.disabled=false;
  }
};

btnManual.onclick=async()=>{
  setProgress(60,'Resolviendo guía (manual)…');
  const type=selType.value, value=parseInt(selValue.value,10), family=inpFamily.value.trim(), year=(inpYear.value||'').trim(), variant=(inpVariant.value||'').trim();
  const url = await resolveGuide({type,value,family,year:year?parseInt(year,10):null,variant});
  if(url){ outUrl.innerHTML=`<a class="link" href="${url}" target="_blank" rel="noopener">${url}</a>`; btnOpenManual.disabled=false; setProgress(100,'Completado'); }
  else { outUrl.textContent='No encontrada'; btnOpenManual.disabled=true; setProgress(0,'—'); }
};
