<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../config/openai.php';

// ==========================================================
// 1. Obtener la(s) imagen(es)
//    - Si viene JSON: { "image_data": "data:image/..." }
//    - Si viene multipart/form-data: campo "file"
// ==========================================================
$ct        = $_SERVER['CONTENT_TYPE'] ?? '';
$dataUrls  = [];

if (stripos($ct, 'application/json') !== false) {
    $j = json_decode(file_get_contents('php://input'), true) ?: [];
    $d = $j['image_data'] ?? null;
    if (is_string($d) && $d !== '') {
        $dataUrls[] = $d;
    }
} else {
    if (!empty($_FILES['file']['tmp_name'])) {
        $bin  = file_get_contents($_FILES['file']['tmp_name']);
        $mime = mime_content_type($_FILES['file']['tmp_name']) ?: 'image/jpeg';
        $dataUrls[] = 'data:' . $mime . ';base64,' . base64_encode($bin);
    }
}

if (empty($dataUrls)) {
    echo json_encode(['ok' => false, 'msg' => 'No image_data ni archivo recibido']);
    exit;
}

// ==========================================================
// 2. Instrucciones para el modelo de visión
//    Enfocado en billetes y monedas de Colombia y compatible
//    con la tabla `denominations`.
// ==========================================================
$instruction = <<<'TXT'
Analiza las imágenes adjuntas de billetes o monedas de COLOMBIA
y devuelve EXCLUSIVAMENTE un JSON (sin texto extra) con el
siguiente esquema:

{
  "type": "billete" | "moneda" | null,
  "value": number | null,
  "family": string | null,
  "year": number | null,
  "variant": string | null,
  "confidence": number,
  "candidates": [
    {
      "type": "billete" | "moneda" | null,
      "value": number | null,
      "family": string | null,
      "year": number | null,
      "variant": string | null,
      "confidence": number
    }
  ]
}

Reglas específicas:

- type: "billete" o "moneda". Si no estás seguro, usa null.
- value: valor numérico en pesos (por ejemplo 1, 10, 50, 200, 2000).
- family: código de familia si es visible, por ejemplo "B020", "B021", "M050".
          Si no está claro, usa null.
- year: año visible de impresión o acuñación si aplica; si no, null.
- variant: texto corto para distinguir variantes cuando proceda:
           por ejemplo "reposicion", "R_pequena", "R_grande", "firmas",
           o una fecha resumida como "30_Sep". Si no hay variante clara, null.
- confidence: número entre 0 y 1 indicando tu confianza global en la identificación.
- candidates: máximo 3 alternativas razonables, con el mismo formato
              {type,value,family,year,variant,confidence}.

Muy importante:
- NO expliques nada.
- NO envíes comentarios.
- NO envíes texto fuera del JSON.
Devuelve solo un JSON válido con las claves indicadas.
TXT;

// ==========================================================
// 3. Llamar a OpenAI
// ==========================================================
$res = openai_chat_vision_extract($dataUrls, $instruction);

if (!$res['ok']) {
    echo json_encode($res);
    exit;
}

// Normalizamos un poco los tipos básicos por si el modelo devuelve strings raras
$data = $res['data'];

if (!is_array($data)) {
    echo json_encode([
        'ok'   => false,
        'msg'  => 'Formato inesperado de datos devueltos por la IA',
        'raw'  => $res['raw'] ?? null,
    ]);
    exit;
}

echo json_encode([
    'ok' => true,
    'ai' => $data,
]);
