<?php
// Conexión PDO genérica a MySQL para el identificador de monedas y billetes.
// Recomendado: sobrescribir estas variables mediante variables de entorno
// DB_HOST, DB_NAME, DB_USER, DB_PASS en tu servidor.

$DB_HOST = getenv('DB_HOST') ?: '127.0.0.1';
$DB_NAME = getenv('DB_NAME') ?: 'REEMPLAZAR_DB_NAME';
$DB_USER = getenv('DB_USER') ?: 'REEMPLAZAR_DB_USER';
$DB_PASS = getenv('DB_PASS') ?: 'REEMPLAZAR_DB_PASS';

$dsn = "mysql:host={$DB_HOST};dbname={$DB_NAME};charset=utf8mb4";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];

try {
    $pdo = new PDO($dsn, $DB_USER, $DB_PASS, $options);
} catch (Throwable $e) {
    http_response_code(500);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        'error'  => 'DB connection failed',
        'detail' => $e->getMessage(),
    ]);
    exit;
}
