<?php require_once __DIR__.'/../config/env.php'; ?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Identificador de Monedas y Billetes — v6</title>
  <link rel="stylesheet" href="css/styles.css">
</head>
<body>
<header>
  <div class="header-inner">
    <h1>Identificador de Monedas y Billetes — v6</h1>
    <?php if (defined('CHATGPT_GPT_URL') && CHATGPT_GPT_URL): ?>
      <a class="link-chatgpt" href="<?php echo htmlspecialchars(CHATGPT_GPT_URL, ENT_QUOTES); ?>" target="_blank" rel="noreferrer">
        Ver asistente en ChatGPT
      </a>
    <?php endif; ?>
  </div>
</header>

<div class="container">
  <div class="card">
    <div class="row">
      <!-- Columna izquierda: captura -->
      <div class="col">
        <div class="top-row">
          <span class="badge" id="status-badge">Listo</span>
        </div>

        <div class="media-wrapper">
          <video id="video" autoplay playsinline></video>
          <canvas id="frame" style="display:none;"></canvas>
          <img id="preview" alt="Vista previa" class="preview" style="display:none;">
        </div>

        <div class="controls">
          <button class="btn btn-tonal" id="btn-start">Activar cámara</button>
          <button class="btn btn-primary" id="btn-ai">Escanear con IA (foto actual)</button>
        </div>

        <div class="upload">
          <label class="btn btn-tonal" id="btn-upload">
            Subir imagen
            <input type="file" id="file" accept="image/*" style="display:none;">
          </label>
        </div>
      </div>

      <!-- Columna derecha: resultados -->
      <div class="col">
        <section class="panel">
          <h2>Resultado de la IA</h2>
          <div class="kv">
            <div>Tipo</div><div id="out-type">—</div>
            <div>Valor</div><div id="out-value">—</div>
            <div>Familia</div><div id="out-family">—</div>
            <div>Año</div><div id="out-year">—</div>
            <div>Variante</div><div id="out-variant">—</div>
            <div>Confianza</div><div id="out-conf">—</div>
          </div>
          <div class="block">
            <label>Resumen</label>
            <div id="out-parsed" class="code small">—</div>
          </div>
          <div class="block">
            <label>Candidatos alternativos</label>
            <div id="out-cands" class="code small">—</div>
          </div>
        </section>

        <section class="panel">
          <h2>Guía Numismática (Numismaticol)</h2>
          <p class="small">
            Ajusta los datos si es necesario y busca la ficha de referencia.
          </p>

          <div class="row row-condensed">
            <div class="col">
              <label for="sel-type">Tipo</label>
              <select id="sel-type">
                <option value="">—</option>
                <option value="billete">Billete</option>
                <option value="moneda">Moneda</option>
              </select>
            </div>
            <div class="col">
              <label for="sel-value">Valor (pesos)</label>
              <input type="number" id="sel-value" placeholder="2000">
            </div>
          </div>

          <div class="row row-condensed">
            <div class="col">
              <label for="inp-family">Familia (ej. B020)</label>
              <input id="inp-family" placeholder="B020">
            </div>
            <div class="col">
              <label for="inp-year">Año</label>
              <input type="number" id="inp-year" placeholder="1966">
            </div>
          </div>

          <div class="row row-condensed">
            <div class="col">
              <label for="inp-variant">Variante</label>
              <input id="inp-variant" placeholder="reposicion, R_pequena...">
            </div>
          </div>

          <div class="controls wrap">
            <button class="btn btn-tonal" id="btn-fill-ai">Usar datos de la IA</button>
            <button class="btn btn-tonal" id="btn-manual">Resolver guía</button>
            <button class="btn btn-primary" id="btn-open-manual" disabled>Abrir guía</button>
          </div>

          <div class="block">
            <label>URL de referencia</label>
            <div id="out-url" class="code small">—</div>
          </div>
        </section>
      </div>
    </div>
  </div>

  <div class="small footer">
    &copy; <?php echo date('Y'); ?> Identificador CO — v6 (IA + Numismaticol)
  </div>
</div>

<script type="module" src="js/app.js"></script>
</body>
</html>
