<?php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__.'/../config/db.php';

$label = trim($_POST['label'] ?? '');
$type  = trim($_POST['type'] ?? '');
$value = isset($_POST['value']) ? (int)$_POST['value'] : 0;

function parseLabel($label){
  $p = explode('_', $label);
  if (!$p || count($p)<2) return [null,null];
  if ($p[0]==='billete') return ['billete', (int)$p[1]];
  if ($p[0]==='moneda')  return ['moneda', (int)$p[1]];
  return [null,null];
}

if ($label){ [$type,$value] = parseLabel($label); }

if (!$type || !$value){ echo json_encode(['ok'=>false,'msg'=>'invalid params']); exit; }

$stmt = $pdo->prepare("SELECT ref_url FROM denominations WHERE type=? AND value=? LIMIT 1");
$stmt->execute([$type, $value]);
$row = $stmt->fetch();
if (!$row){ echo json_encode(['ok'=>false,'msg'=>'not found']); exit; }

echo json_encode(['ok'=>true, 'url'=>$row['ref_url']]);
