<?php ?><!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Identificador CO — Web (Pro v2)</title>
  <link rel="stylesheet" href="css/styles.css">
  <script async src="https://docs.opencv.org/4.x/opencv.js" onload="window.__cvReady=true;" onerror="window.__cvReady=false;"></script>
</head>
<body>
<header><h1>Identificador de Monedas y Billetes — Web (Pro v2)</h1></header>
<div class="container">
  <div class="card">
    <div class="row">
      <div class="col">
        <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:8px;">
          <span class="badge" id="status-badge">Listo</span>
          <div class="small" style="display:flex;gap:12px;align-items:center;">
            <label><input type="checkbox" id="toggle-mock" checked> Modo simulado</label>
            <label><input type="checkbox" id="toggle-fine" checked> Verificación fina</label>
            <label><input type="checkbox" id="toggle-auto" checked> Autocaptura</label>
          </div>
        </div>
        <video id="video" autoplay playsinline muted></video>
        <canvas id="frame" style="display:none;"></canvas>
        <div style="display:flex;gap:8px;margin-top:10px;">
          <button class="btn btn-tonal" id="btn-start">Encender cámara</button>
          <button class="btn btn-tonal" id="btn-scan">Escanear</button>
          <button class="btn btn-primary" id="btn-open" disabled>Ver guía en Numismaticol</button>
        </div>
        <p class="small" style="margin-top:8px;">
          Cámara requiere <span class="code">https</span> o <span class="code">http://localhost</span>.
          Si OpenCV.js no carga, se omite la verificación fina.
        </p>
      </div>
      <div class="col">
        <div class="card" style="margin:0">
          <h3 style="margin-top:0;">Resultado</h3>
          <div class="kv">
            <div><strong>Label:</strong></div><div id="out-label">—</div>
            <div><strong>Confianza:</strong></div><div id="out-conf">—</div>
            <div><strong>Tipo/Valor:</strong></div><div id="out-parsed">—</div>
            <div><strong>URL guía:</strong></div><div id="out-url">—</div>
            <div><strong>Foco/Nitidez:</strong></div><div id="out-sharp">—</div>
            <div><strong>ROIs:</strong></div><div id="out-rois">—</div>
          </div>
          <hr>
          <h4>Prueba manual</h4>
          <div class="row">
            <div class="col">
              <label>Tipo</label>
              <select id="sel-type">
                <option value="billete">Billete</option>
                <option value="moneda">Moneda</option>
              </select>
            </div>
            <div class="col">
              <label>Valor</label>
              <select id="sel-value">
                <option>10</option>
                <option>2</option>
                <option>2000</option>
                <option>50</option>
                <option>100</option>
                <option>200</option>
                <option>500</option>
                <option>1000</option>
              </select>
            </div>
          </div>
          <div class="row" style="margin-top:8px;">
            <div class="col">
              <label>Año (opcional)</label>
              <input id="inp-year" placeholder="1970, 2004, etc.">
            </div>
            <div class="col">
              <label>Variante (opcional)</label>
              <input id="inp-variant" placeholder="reposicion_R_pequena">
            </div>
          </div>
          <div style="margin-top:8px;display:flex;gap:8px;">
            <button class="btn btn-tonal" id="btn-manual">Resolver guía (manual)</button>
            <button class="btn btn-primary" id="btn-open-manual" disabled>Abrir guía (manual)</button>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="small" style="opacity:.7;text-align:center;padding:16px 0 28px;">
    &copy; <?php echo date('Y'); ?> Identificador CO · Integrado con <strong>Numismaticol</strong>
  </div>
</div>
<script>const API_BASE = "../api";</script>
<script type="module" src="js/app.js"></script>
</body></html>
